Public Class UPVReport
    Inherits System.Windows.Forms.Form

    Private _PrintArguments As System.Drawing.Printing.PrintPageEventArgs
    Private _CurrentYLocation As Integer
    Private _XLeft As Integer
    Private _HeadlineFont As System.Drawing.Font = New System.Drawing.Font("Verdana", 16, System.Drawing.FontStyle.Bold)
    Private _SubHeadlineFont As System.Drawing.Font = New System.Drawing.Font("Verdana", 12, System.Drawing.FontStyle.Bold)
    Private _TextFont As System.Drawing.Font = New System.Drawing.Font("Verdana", 10, System.Drawing.FontStyle.Regular)
    Private _BoldTextFont As System.Drawing.Font = New System.Drawing.Font("Verdana", 10, System.Drawing.FontStyle.Bold)
    Private _LabelFont As System.Drawing.Font = New System.Drawing.Font("Arial", 12, System.Drawing.FontStyle.Bold)
    Private _HeaderWidth As Single = 150
    Private _Logo As System.Drawing.Image
    Private _gr As Graphics
    Private _PrintRect As Rectangle
    Private _HeadlineSpace As Single = 10
    Private _ImageSpace As Single = 10
    Private _SubHeadlineSpace As Single = 10
    Private _PreSubHeadlineSpace As Single = 10
    Private _TextSpace As Single = 5
    Private _LineSpace As Single = 5
    Private _TableSpace As Single = 10
    Private _HeadlineBrush As New SolidBrush(Color.Black)
    Private _SubHeadlineBrush As New SolidBrush(Color.Black)
    Private _TextBrush As New SolidBrush(Color.Black)
    Private _LabelBrush As New SolidBrush(Color.Black)
    Private _LinePen As New System.Drawing.Pen(Color.Black, 1)

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()
        SetPageMargins()
        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents PrintDocument1 As System.Drawing.Printing.PrintDocument
    Friend WithEvents PageSetupDialog1 As System.Windows.Forms.PageSetupDialog
    Friend WithEvents PrintDialog1 As System.Windows.Forms.PrintDialog
    Friend WithEvents PrintPreviewDialog1 As System.Windows.Forms.PrintPreviewDialog
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(UPVReport))
        Me.PrintDocument1 = New System.Drawing.Printing.PrintDocument
        Me.PageSetupDialog1 = New System.Windows.Forms.PageSetupDialog
        Me.PrintDialog1 = New System.Windows.Forms.PrintDialog
        Me.PrintPreviewDialog1 = New System.Windows.Forms.PrintPreviewDialog
        '
        'PrintDocument1
        '
        '
        'PrintPreviewDialog1
        '
        Me.PrintPreviewDialog1.AutoScrollMargin = New System.Drawing.Size(0, 0)
        Me.PrintPreviewDialog1.AutoScrollMinSize = New System.Drawing.Size(0, 0)
        Me.PrintPreviewDialog1.ClientSize = New System.Drawing.Size(400, 300)
        Me.PrintPreviewDialog1.Enabled = True
        Me.PrintPreviewDialog1.Icon = CType(resources.GetObject("PrintPreviewDialog1.Icon"), System.Drawing.Icon)
        Me.PrintPreviewDialog1.Location = New System.Drawing.Point(397, 16)
        Me.PrintPreviewDialog1.MinimumSize = New System.Drawing.Size(375, 250)
        Me.PrintPreviewDialog1.Name = "PrintPreviewDialog1"
        Me.PrintPreviewDialog1.TransparencyKey = System.Drawing.Color.Empty
        Me.PrintPreviewDialog1.Visible = False
        '
        'UPVReport
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.BackgroundImage = CType(resources.GetObject("$this.BackgroundImage"), System.Drawing.Image)
        Me.ClientSize = New System.Drawing.Size(344, 245)
        Me.ForeColor = System.Drawing.SystemColors.ControlDarkDark
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.Name = "UPVReport"
        Me.Text = "UPVReport"

    End Sub

#End Region

    Public Event PrintPage()

    Public Class ReportTable

        Structure TableRow
            Dim Cell() As String
        End Structure
        Private MyRowCount As Byte
        Private MyColumnCount As Byte
        Private MyHasRowHeader As Boolean
        Private MyHasColumnHeader As Boolean
        Private MyLineWidth As Integer = 1
        Private MyLineColor As System.Drawing.Color = Color.Gray
        Private MyRowHeader() As String
        Private MyColumnHeader() As String
        Private MyCell() As TableRow

        Private Function ColumnToStringArray(ByVal SelectedColumn As Integer) As String()
            Dim Result(MyRowCount) As String
            Dim Index As Integer
            If SelectedColumn <= MyColumnCount Then
                For Index = 0 To MyRowCount
                    Result(Index) = MyCell(Index).Cell(0)
                Next
            End If
            Return Result
        End Function

        Public Sub New(ByVal ColumnCount As Byte, ByVal RowCount As Byte, ByVal WithColumnHeader As Boolean, ByVal WithRowHeader As Boolean)
            Dim Index As Integer

            MyColumnCount = ColumnCount
            MyRowCount = RowCount
            MyHasColumnHeader = WithColumnHeader
            MyHasRowHeader = WithRowHeader
            ReDim MyCell(MyRowCount)
            For Index = 0 To MyRowCount
                ReDim MyCell(Index).Cell(MyColumnCount)
            Next
        End Sub

        Public Property Cell(ByVal Row As Byte, ByVal Column As Byte) As String
            Get
                If (Row <= MyRowCount) And (Column <= MyColumnCount) And (Row >= 0) And (Column >= 0) Then
                    Return MyCell(Row).Cell(Column)
                End If
            End Get
            Set(ByVal Value As String)
                If (Row <= MyRowCount) And (Column <= MyColumnCount) And (Row > 0) And (Column > 0) Then
                    MyCell(Row).Cell(Column) = Value
                End If
            End Set
        End Property

        Public Property ColumnHeader() As String()
            Get
                Return MyCell(0).Cell
            End Get
            Set(ByVal Value As String())
                If Value.Length = MyColumnCount + 1 Then
                    MyCell(0).Cell = Value
                End If
            End Set
        End Property

        Public Property RowHeader() As String()
            Get
                Return ColumnToStringArray(0)
            End Get
            Set(ByVal Value As String())
                Dim Index As Integer
                If Value.Length = MyRowCount Then
                    For Index = 1 To MyRowCount
                        MyCell(Index).Cell(0) = Value(Index - 1)
                    Next
                End If
            End Set
        End Property

        Public Property HasRowHeader() As Boolean
            Get
                Return MyHasRowHeader
            End Get
            Set(ByVal Value As Boolean)
                MyHasRowHeader = Value
            End Set
        End Property

        Public Property HasColumnHeader() As Boolean
            Get
                Return MyHasColumnHeader
            End Get
            Set(ByVal Value As Boolean)
                MyHasColumnHeader = Value
            End Set
        End Property

        Public Property RowCount() As Byte
            Get
                Return MyRowCount
            End Get
            Set(ByVal Value As Byte)
                MyRowCount = Value
            End Set
        End Property

        Public Property ColumnCount() As Byte
            Get
                Return MyColumnCount
            End Get
            Set(ByVal Value As Byte)
                MyColumnCount = Value
            End Set
        End Property

    End Class

    Private Sub SetPageMargins()
        PrintDocument1.DefaultPageSettings.Margins = New System.Drawing.Printing.Margins(60, 30, 30, 60)
    End Sub

    Public Structure DataRow
        Dim Header As String
        Dim Data As String
    End Structure

    Public Sub PageSetup()
        Dim ri As Globalization.RegionInfo = Globalization.RegionInfo.CurrentRegion
        Dim DiagRes As DialogResult

        If _gr Is Nothing Then
            With PrintDocument1.DefaultPageSettings.Margins
                'If ri.IsMetric Then
                '    .Bottom = 
                'End If
            End With
            With PageSetupDialog1
                .Document = PrintDocument1
                If ri.IsMetric Then                         'Workaround for bug in VB2003 only!
                    .PageSettings.Margins.Left *= 2.54
                    .PageSettings.Margins.Top *= 2.54
                    .PageSettings.Margins.Right *= 2.54
                    .PageSettings.Margins.Bottom *= 2.54
                End If
                DiagRes = .ShowDialog()
            End With
            If DiagRes = DialogResult.Cancel And ri.IsMetric Then   'Workaround for bug in VB2003 only!
                With PrintDocument1
                    .DefaultPageSettings.Margins.Left /= 2.54
                    .DefaultPageSettings.Margins.Top /= 2.54
                    .DefaultPageSettings.Margins.Right /= 2.54
                    .DefaultPageSettings.Margins.Bottom /= 2.54
                End With
            End If
        Else
            Throw New Exception("'UPVReport.PageSetup' is not accessible during print event handling.")
        End If
    End Sub

    Public Sub PrintDialog()
        With PrintDialog1
            .Document = PrintDocument1
            .AllowSomePages = True
            If .ShowDialog = DialogResult.OK Then
                PrintDocument1.Print()
            End If
        End With
    End Sub

    Public Sub PrintPreview()
        With PrintPreviewDialog1
            .Document = PrintDocument1
            .WindowState = FormWindowState.Maximized
            .ShowDialog()
        End With
    End Sub

    Public Sub Print()
        PrintDocument1.Print()
    End Sub

    Public Sub AppendImage(ByVal Img As System.Drawing.Image)
        If _gr Is Nothing Then
            Throw New Exception("'UPVReport.AppendImage' is accessible only during print event handling.")
        Else
            _gr.DrawImage(Img, New System.Drawing.PointF(_XLeft, _CurrentYLocation))
            _CurrentYLocation += Img.Height + _ImageSpace
        End If
    End Sub

    Public Sub AppendImage(ByVal Img As System.Drawing.Image, ByVal Label As String, ByVal LabelXPosition As Integer, ByVal LabelYPosition As Integer)
        If _gr Is Nothing Then
            Throw New Exception("'UPVReport.AppendImage' is accessible only during print event handling.")
        Else
            _gr.DrawImage(Img, New System.Drawing.PointF(_XLeft, _CurrentYLocation))
            Dim LabelRectangle As New System.Drawing.RectangleF(_XLeft + LabelXPosition, _CurrentYLocation + LabelYPosition, _XLeft + Img.Width, _LabelFont.Height)
            _gr.DrawString(Label, _LabelFont, _LabelBrush, LabelRectangle)
            _CurrentYLocation += Img.Height + _ImageSpace
        End If
    End Sub

    Public Sub AppendHeadline(ByVal HeadlineText As String)
        If _gr Is Nothing Then
            Throw New Exception("'UPVReport.AppendHeadline' is accessible only during print event handling.")
        Else
            Dim HeadlineRectangle As New System.Drawing.RectangleF(_PrintRect.Left, _PrintRect.Top + _Logo.Height - 0.8 * _HeadlineFont.Height, _PrintArguments.MarginBounds.Width - _Logo.Width, _HeadlineFont.Height)
            _gr.DrawString(HeadlineText, _HeadlineFont, _HeadlineBrush, HeadlineRectangle)
            _CurrentYLocation += _Logo.Height + _HeadlineSpace
        End If
    End Sub

    Public Sub AppendSubHeadline(ByVal SubHeadlineText As String)
        If _gr Is Nothing Then
            Throw New Exception("'UPVReport.AppendSubHeadline' is accessible only during print event handling.")
        Else
            _CurrentYLocation += _PreSubHeadlineSpace
            Dim SubHeadlineRectangle As New System.Drawing.RectangleF(_PrintRect.Left, _CurrentYLocation, _PrintArguments.MarginBounds.Width - _Logo.Width, _SubHeadlineFont.Height)
            _gr.DrawString(SubHeadlineText, _SubHeadlineFont, _SubHeadlineBrush, SubHeadlineRectangle)
            _CurrentYLocation += SubHeadlineRectangle.Height + _SubHeadlineSpace
        End If
    End Sub

    Public Sub AppendValueLine(ByVal HeaderText As String, ByVal ValueText As String)
        If _gr Is Nothing Then
            Throw New Exception("'UPVReport.AppendSubHeadline' is accessible only during print event handling.")
        Else
            Dim HeaderRectangle As New System.Drawing.RectangleF(_PrintRect.Left, _CurrentYLocation, _HeaderWidth, _TextFont.Height)
            Dim ValueRectangle As New System.Drawing.RectangleF(_PrintRect.Left + _HeaderWidth, _CurrentYLocation, _PrintRect.Width - _HeaderWidth, _TextFont.Height)
            _gr.DrawString(HeaderText, _BoldTextFont, _TextBrush, HeaderRectangle)
            _gr.DrawString(ValueText, _TextFont, _TextBrush, ValueRectangle)
            _CurrentYLocation += HeaderRectangle.Height + _TextSpace
        End If
    End Sub

    Public Sub AppendText(ByVal Text As String, ByVal LineCount As Integer)
        If _gr Is Nothing Then
            Throw New Exception("'UPVReport.AppendSubHeadline' is accessible only during print event handling.")
        Else
            Dim TextRectangle As New System.Drawing.RectangleF(_PrintRect.Left, _CurrentYLocation, _PrintRect.Width, LineCount * _TextFont.Height)
            _gr.DrawString(Text, _TextFont, _SubHeadlineBrush, TextRectangle)
            _CurrentYLocation += TextRectangle.Height + _TextSpace
        End If
    End Sub

    Public Sub AppendTable(ByVal Tbl As ReportTable, ByVal Borders As Boolean)
        Dim RptColumnCount As Byte
        Dim RptRowCount As Byte
        Dim ColumnStartindex As Byte
        Dim RowStartindex As Byte
        Dim ColumnIndex As Byte
        Dim RowIndex As Byte
        Dim CellWidth As Integer
        Dim Cell1Left As Integer

        If _gr Is Nothing Then
            Throw New Exception("'UPVReport.AppendTable' is accessible only during print event handling.")
        Else
            If Tbl.HasColumnHeader Then
                RptColumnCount = Tbl.ColumnCount + 1
                ColumnStartindex = 0
            Else
                RptColumnCount = Tbl.ColumnCount
                ColumnStartindex = 1
            End If
            If Tbl.HasRowHeader Then
                RptRowCount = Tbl.RowCount + 1
                RowStartindex = 0
            Else
                RptRowCount = Tbl.RowCount
                RowStartindex = 1
            End If
            CellWidth = CInt(Math.Round(_PrintRect.Width / RptColumnCount - 0.5))
            If Tbl.HasRowHeader Then
                Cell1Left = _PrintRect.Left + CellWidth
            Else
                Cell1Left = _PrintRect.Left
            End If
            If Tbl.HasColumnHeader Then
                For ColumnIndex = 1 To Tbl.ColumnCount
                    Dim CellRectangle As New System.Drawing.RectangleF(Cell1Left + (ColumnIndex - 1) * CellWidth, _CurrentYLocation, CellWidth, _BoldTextFont.Height)
                    _gr.DrawString(Tbl.Cell(0, ColumnIndex), _BoldTextFont, _TextBrush, CellRectangle)
                Next
                _CurrentYLocation += _BoldTextFont.Height
            End If
            For RowIndex = 1 To Tbl.RowCount
                If Tbl.HasRowHeader Then
                    Dim CellRectangle As New System.Drawing.RectangleF(_PrintRect.Left, _CurrentYLocation, CellWidth, _BoldTextFont.Height)
                    _gr.DrawString(Tbl.Cell(RowIndex, 0), _BoldTextFont, _TextBrush, CellRectangle)

                End If
                For ColumnIndex = 1 To Tbl.ColumnCount
                    Dim CellRectangle As New System.Drawing.RectangleF(Cell1Left + (ColumnIndex - 1) * CellWidth, _CurrentYLocation, _HeaderWidth, _TextFont.Height)
                    _gr.DrawString(Tbl.Cell(RowIndex, ColumnIndex), _TextFont, _TextBrush, CellRectangle)
                Next
                _CurrentYLocation += _TextFont.Height
            Next
            _CurrentYLocation += _TableSpace
        End If
    End Sub

    Public Sub PlaceString(ByVal Text As String, ByVal RelXPosition As Single, ByVal RelYPosition As Single, ByVal Width As Single)
        Debug.WriteLine("PlaceString  " & Text & "  " & RelXPosition.ToString & RelYPosition.ToString & Width.ToString)
        Dim TextRectangle As New System.Drawing.RectangleF(_PrintRect.Left + RelXPosition, _CurrentYLocation + RelYPosition, _PrintRect.Width, _TextFont.Height)
        _gr.DrawString(Text, _TextFont, _TextBrush, TextRectangle)
    End Sub

    Public Sub HorizontalLine()
        _gr.DrawLine(_LinePen, _PrintRect.Left, _CurrentYLocation, _PrintRect.Right, _CurrentYLocation)
        _CurrentYLocation += _LineSpace
    End Sub

    Private Sub PrintDocument1_PrintPage(ByVal sender As Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs) Handles PrintDocument1.PrintPage
        'e.Graphics.PageUnit = GraphicsUnit.Millimeter
        'e.MarginBounds = New System.Drawing.Rectangle(20, 10, 170, 275)
        Debug.WriteLine("e.Graphics.PageUnit = " & e.Graphics.PageUnit.ToString)
        Debug.WriteLine("PrintDocument1.PrintPage, Margin Bounds = " & e.MarginBounds.ToString)
        _Logo = Me.BackgroundImage
        _PrintArguments = e
        _gr = _PrintArguments.Graphics
        _PrintRect = e.MarginBounds
        Debug.WriteLine("_PrintRect = " & _PrintRect.ToString)
        _CurrentYLocation = _PrintArguments.MarginBounds.Top
        _XLeft = _PrintRect.Left
        Debug.WriteLine("Drawing logo, _PrintRect.Right = " & _PrintRect.Right.ToString & "  _Logo.Width = " & _Logo.Width.ToString)
        _gr.DrawImage(_Logo, New System.Drawing.PointF(_PrintRect.Right - _Logo.Width - 10, _CurrentYLocation))
        Debug.WriteLine("Raising event ...")
        RaiseEvent PrintPage()
    End Sub
End Class
